/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xhif.h
 * -----------------------------------------------------------------*/

#ifndef XHIF_H_INCLUDED
#define XHIF_H_INCLUDED

#include <xtypedef.h>
#include <xio.h>

/* SCRobinson, 10/97
 * This file contains function declarations for accessing 
 * the Fast-Host-Interface card (Win95 or WinNT PCI-drivers ONLY) from the
 * CAPI.
 *
 * These functions are contained in fhif32.c and called by wrapper functions 
 * in session.c or iocommon.c which switch between the different ports.
 *
 * *** IMPORTANT ***
 * Although the FastHIF has its own PCI driver which we use for reads/writes
 * we also use the gen. purpose BestX PCI driver to get slotdata and 
 * device id's for different FastHIF cards.
 *
 * Therefore bx_ntpcix.sys MUST BE ACTIVE ON THE HOST SYSTEM !!!
 */

/* these functions are in fhif32.c */

/* --------------------------------------------------------------------------
 * Standard I/O functions (see iocommon.c)
 * -------------------------------------------------------------------------- */

  bx_errtype BestXHIFDeviceConnect(bx_portnumtype OsHandle);
  bx_errtype BestXHIFCheckConnection(bx_portnumtype OsHandle);
  bx_errtype BestXHIFIsDisconnected(bx_portnumtype OsHandle);
void BestXHIFReleaseConnection(bx_portnumtype OsHandle);
  bx_errtype BestXHifPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* Default timeouts are defined in bx_io.h */


/* --------------------------------------------------------------------------
 * Other exposed functions
 * -------------------------------------------------------------------------- */

  bx_errtype BestXOpenHIF(bx_int32 dwCardId, 
  bx_int32 * pHPSlotId, 
  bx_portnumtype * pOsHandle );

  bx_errtype BestXCloseHIF(bx_portnumtype OsHandle);

/* --------------------------------------------------------------------------
 * **TODO** Remove when ReadFile() and WriteFile() work.
 * -------------------------------------------------------------------------- */
  bx_errtype BestXHIFIoCtlRead(bx_handletype handle, 
  bx_int8 * pData,
  bx_int32 NumBytes,
  bx_int32 * pNumBytesRead,
  bx_int32 IoCtlCode);

  bx_errtype BestXHIFIoCtlWrite( bx_handletype handle, 
  bx_int8 * pData,
  bx_int32 NumBytes,
  bx_int32 * pNumBytesWritten,
  bx_int32 IoCtlCode);


#endif /* _BX_HIF_H */
